# Contributing to OWASP CSRF Protector PHP
CSRF Protector is a community project, and we are always delighted to welcome new contributors!

There are lots of ways you can contribute:

## Got a Question or Problem?
If you have a question or problem relating to using this project then the first thing to do is to check:
 - **Project Wiki**: We have a comprehensive User Guide for CSRF Protector in our [Github Wiki](https://github.com/mebjas/CSRF-Protector-PHP/wiki).
 - **OWASP Wiki**: We have more information about the project and sibling projects at [https://www2.owasp.org/www-project-csrfprotector/](https://www2.owasp.org/www-project-csrfprotector/).
 - **Articles online**: We have some articles online on how to use or new features introduced like:
    - [CSRF Protector - concept design & future](https://blog.minhazav.dev/CSRF-Protector-concept-design-and-future/)
    - [Session based login compatibility issues with CSRF - how to mitigate](https://blog.minhazav.dev/logging-out-and-then-logging-in-throws-403-error-with-csrf-protector/)
    - [Minor improvements to CSRF Protector PHP](https://blog.minhazav.dev/introducing-minor-improvements-to-csrf-protector-php/)
 - **Google groups**: If they don't help then please ask on the [User Group](https://groups.google.com/a/owasp.org/forum/#!forum/csrfprotector-project)

## Found an Issue?
If you have found a bug then raise an issue on the CSRF Protector repo: [https://github.com/mebjas/CSRF-Protector-PHP/issues](https://github.com/mebjas/CSRF-Protector-PHP/issues)

Its worth checking to see if its already been reported, and including as much information as you can to help us diagnose your problem.

## Found a Vulnerability?
If you think you have found a vulnerability in CSRF Protector then please report it directly on email at [minhazav@gmail.com](mailto:https://github.com/mebjas/CSRF-Protector-PHP/issues) or [minhaz@owasp.org](mailto: minhaz@owasp.org)

We are always very grateful to researchers who report vulnerabilities responsibly and will be very happy to give credit for the valuable assistance they provide.

## Have a Feature Request?
If you have a suggestion for new functionality then you can raise an issue on the CSRF Protector PHP repo: [https://github.com/mebjas/CSRF-Protector-PHP/issues](https://github.com/mebjas/CSRF-Protector-PHP/issues)

Its worth checking to see if its already been requested, and including as much information as you can so that we can fully understand your requirements.

## Become a CSRF Protector Evangelist
Please feel free to write more about this project on how it works or how to use it. Please feel free to send a [pull request](https://github.com/mebjas/CSRF-Protector-PHP/pulls) by adding a reference to your article in the `README.md` or `CONTRIBUTING.md`.

## Help Improve the Documentation
The source for the CSRF Protector OWASP wiki [User Guide is hosted at OWASP/www-project-csrfprotector](https://github.com/OWASP/www-project-csrfprotector) and is hosted at [https://www2.owasp.org/www-project-csrfprotector/](https://www2.owasp.org/www-project-csrfprotector/). Please feel free to send a [pull request](https://github.com/OWASP/www-project-csrfprotector/pulls) to add updates to the documentation.

## Coding

There's always lots of coding to be done! If you feel something can be improved feel free to send a pull request.
