<?php
/**
 * Teampass - a collaborative passwords manager.
 * ---
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * ---
 * @project   Teampass
 * @file      upgrade_scripts_manager.php
 * ---
 * @author    Nils Laumaillé (nils@teampass.net)
 * @copyright 2009-2023 Teampass.net
 * @license   https://spdx.org/licenses/GPL-3.0-only.html#licenseText GPL-3.0
 * ---
 * @see       https://www.teampass.net
 */

set_time_limit(600);


require_once './libs/SecureHandler.php';
session_name('teampass_session');
session_start();
error_reporting(E_ERROR | E_PARSE);
$_SESSION['db_encoding'] = 'utf8';
$_SESSION['CPM'] = 1;
require_once '../includes/config/include.php';

// Prepare POST variables
$post_file_number = filter_input(INPUT_POST, 'file_number', FILTER_SANITIZE_NUMBER_INT);

$scripts_list = array(
    array('upgrade_run_3.0.0.php', 'user_id'),
    array('upgrade_run_3.0.0_passwords.php', 'user_id'),
    array('upgrade_run_3.0.0_logs.php', 'user_id'),
    array('upgrade_run_3.0.0_fields.php', 'user_id'),
    array('upgrade_run_3.0.0_suggestions.php', 'user_id'),
    array('upgrade_run_3.0.0_files.php', 'user_id'),
    array('upgrade_run_3.0.php', 'user_id'),
    array('upgrade_operations.php', '20230604_1'),
    array('upgrade_operations.php', 'populateItemsTable_CreatedAt'),
    array('upgrade_operations.php', 'populateItemsTable_UpdatedAt'),
    array('upgrade_operations.php', 'populateItemsTable_DeletedAt'),
    array('upgrade_operations.php', '20231017_1'),
    array('upgrade_run_3.1.php', 'user_id'),
);
$param = '';

// test if finished
if (intval($post_file_number) >= count($scripts_list)) {
    $finished = 1;
} else {
    $finished = 0;
}
echo '[{"finish":"'.$finished.'", "scriptname":"'.$scripts_list[$post_file_number][0].'", "parameter":"'.$scripts_list[$post_file_number][1].'"}]';
