'use strict';

// first start - my be reworked to use 'COMMANDS' or 'COMMAND INFO' command if available (redis >=2.8.13)
// but this will be fallback if they are not working (for whatever reason)
const _readCmdsV3 = [
  'REFRESH',
  'AUTH password',
  'BITCOUNT key [start] [end]',
  'BITOP operation destkey key [key ...]',
  'BITPOS key bit [start] [end]',
  'CLIENT LIST [TYPE normal|master|replica|pubsub]',
  'CLIENT GETNAME',
  'CLUSTER COUNT-FAILURE-REPORTS node-id',
  'CLUSTER COUNTKEYSINSLOT slot',
  'CLUSTER GETKEYSINSLOT slot count',
  'CLUSTER INFO',
  'CLUSTER KEYSLOT key',
  'CLUSTER NODES',
  'CLUSTER SLAVES node-id',
  'CLUSTER REPLICAS node-id',
  'CLUSTER SLOTS',
  'COMMANDS',
  'COMMAND COUNT',
  'COMMAND GETKEYS',
  'COMMAND INFO command-name [command-name ...]',
  'CONFIG GET parameter',
  'DBSIZE',
  'DEBUG OBJECT key',
  'DISCARD',
  'DUMP key',
  'ECHO message',
  'EXEC',
  'EXISTS key',
  'GET key',
  'GETBIT key offset',
  'GETRANGE key start end',
  'HEXISTS key field',
  'HGET key field',
  'HGETALL key',
  'HKEYS key',
  'HLEN key',
  'HMGET key field [field ...]',
  'HSCAN key cursor [MATCH pattern] [COUNT count]',
  'HVALS key',
  'INFO [section]',
  'KEYS pattern',
  'LASTSAVE',
  'LINDEX key index',
  'LLEN key',
  'LRANGE key start stop',
  'MGET key [key ...]',
  'MONITOR',
  'MULTI',
  'OBJECT subcommand [arguments ...]',
  'PING [message]',
  'PUBSUB CHANNELS [pattern]',
  'PUBSUB NUMSUB [channel-1 ...]',
  'PUBSUB NUMPAT',
  'PSUBSCRIBE pattern [pattern ...]',
  'PTTL key',
  'PUNSUBSCRIBE [pattern ...]',
  'QUIT',
  'RANDOMKEY',
  'ROLE',
  'SCAN cursor [MATCH pattern] [COUNT count]',
  'SCARD key',
  'SDIFF key [key ...]',
  'SELECT index',
  'SINTER key [key ...]',
  'SISMEMBER key member',
  'SMEMBERS key',
  'SRANDMEMBER key [count]',
  'SSCAN key cursor [MATCH pattern] [COUNT count]',
  'STRLEN key',
  'SUBSCRIBE channel [channel ...]',
  'SUNION key [key ...]',
  'TIME',
  'TTL key',
  'TYPE key',
  'UNSUBSCRIBE [channel ...]',
  'UNWATCH',
  'WATCH key [key ...]',
  'ZCARD key',
  'ZCOUNT key min max',
  'ZLEXCOUNT key min max',
  'ZRANGE key start stop [WITHSCORES]',
  'ZRANGEBYLEX key min max [LIMIT offset count]',
  'ZRANGEBYSCORE key min max [WITHSCORES] [LIMIT offset count]',
  'ZRANK key member',
  'ZREVRANGE key start stop [WITHSCORES]',
  'ZREVRANGEBYLEX key max min [LIMIT offset count]',
  'ZREVRANGEBYSCORE key max min [WITHSCORES] [LIMIT offset count]',
  'ZREVRANK key member',
  'ZSCAN key cursor [MATCH pattern] [COUNT count]',
  'ZSCORE key member'
];

const _readCmdsV32 = _readCmdsV3.concat([
  'CLIENT REPLY ON|OFF|SKIP',
  'GEOHASH key member [member ...]',
  'GEOPOS key member [member ...]',
  'GEODIST key member1 member2 [unit]',
  'HSTRLEN key field'
]);

const _readCmdsV4 = _readCmdsV32.concat([
  'MEMORY DOCTOR',
  'MEMORY HELP',
  'MEMORY MALLOC-STATS',
  'MEMORY STATS',
  'MEMORY USAGE key [SAMPLES count]'
]);

const _readCmdsV5 = _readCmdsV4.concat([
  'CLIENT ID',
  'XINFO [CONSUMERS key groupname] [GROUPS key] [STREAM key] [HELP]',
  'XRANGE key start end [COUNT count]',
  'XREVRANGE key end start [COUNT count]',
  'XLEN key',
  'XREAD [COUNT count] [BLOCK milliseconds] STREAMS key [key ...] ID [ID ...]',
  'XREADGROUP GROUP group consumer [COUNT count] [BLOCK milliseconds] [NOACK] STREAMS key [key ...] ID [ID ...]',
  'XPENDING key group [start end count] [consumer]'
]);



module.exports = {
  readCmds: _readCmdsV5,
  writeCmds: [
    'APPEND key value',
    'BGREWRITEAOF',
    'BGSAVE',
    'BLPOP key [key ...] timeout',
    'BRPOP key [key ...] timeout',
    'BRPOPLPUSH source destination timeout',
    'CONFIG SET parameter value',
    'CONFIG RESETSTAT',
    'DEBUG SEGFAULT',
    'DECR key',
    'DECRBY key decrement',
    'DEL key [key ...]',
    'DISCARD',
    'EVAL script numkeys key [key ...] arg [arg ...]',
    'EVALSHA sha1 numkeys key [key ...] arg [arg ...]',
    'EXPIRE key seconds',
    'EXPIREAT key timestamp',
    'FLUSHALL',
    'FLUSHDB',
    'GETSET key value',
    'HDEL key field [field ...]',
    'HINCRBY key field increment',
    'HINCRBYFLOAT key field increment',
    'HMSET key field value [field value ...]',
    'HSET key field value',
    'HSETNX key field value',
    'INCR key',
    'INCRBY key increment',
    'INCRBYFLOAT key increment',
    'LINSERT key BEFORE|AFTER pivot value',
    'LPOP key',
    'LPUSH key value [value ...]',
    'LPUSHX key value',
    'LREM key count value',
    'LSET key index value',
    'LTRIM key start stop',
    'MIGRATE host port key destination-db timeout',
    'MOVE key db',
    'MSET key value [key value ...]',
    'MSETNX key value [key value ...]',
    'OBJECT subcommand [arguments ...]',
    'PERSIST key',
    'PEXPIRE key milliseconds',
    'PEXPIREAT key milliseconds-timestamp',
    'PSETEX key milliseconds value',
    'PSUBSCRIBE pattern [pattern ...]',
    'PUBLISH channel message',
    'RENAME key newkey',
    'RENAMENX key newkey',
    'RESTORE key ttl serialized-value',
    'RPOP key',
    'RPOPLPUSH source destination',
    'RPUSH key value [value ...]',
    'RPUSHX key value',
    'SADD key member [member ...]',
    'SAVE',
    'SCRIPT EXISTS script [script ...]',
    'SCRIPT FLUSH',
    'SCRIPT KILL',
    'SCRIPT LOAD script',
    'SDIFFSTORE destination key [key ...]',
    'SET key value',
    'SETBIT key offset value',
    'SETEX key seconds value',
    'SETNX key value',
    'SETRANGE key offset value',
    'SHUTDOWN [NOSAVE|SAVE]',
    'SINTERSTORE destination key [key ...]',
    'SLAVEOF host port',
    'SLOWLOG subcommand [argument]',
    'SMOVE source destination member',
    'SORT key [BY pattern] [LIMIT offset count] [GET pattern [GET pattern ...]] [ASC|DESC] [ALPHA] [STORE destination]',
    'SPOP key',
    'SREM key member [member ...]',
    'SUNIONSTORE destination key [key ...]',
    'SYNC',
    'ZADD key score member [score] [member]',
    'ZINCRBY key increment member',
    'ZINTERSTORE destination numkeys key [key ...] [WEIGHTS weight [weight ...]] [AGGREGATE SUM|MIN|MAX]',
    'ZREM key member [member ...]',
    'ZREMRANGEBYLEX key min max',
    'ZREMRANGEBYRANK key start stop',
    'ZREMRANGEBYSCORE key min max',
    'ZUNIONSTORE destination numkeys key [key ...] [WEIGHTS weight [weight ...]] [AGGREGATE SUM|MIN|MAX]'
  ]
};
