<?php
/**
 * Names for special pages
 *
 * @file
 * @ingroup Extensions
 */

// global needed in order to be used inside of ProofreadPageInit
global $proofreadPageNamespaceNames, $proofreadPageNamespaceAliases;
$proofreadPageNamespaceNames = [];
$proofreadPageNamespaceAliases = [];

/** English (English) */
$proofreadPageNamespaceNames['en'] = [
	'page' => 'Page',
	'page_talk' => 'Page_talk',
	'index' => 'Index',
	'index_talk' => 'Index_talk'
];

/** Arabic (العربية) */
$proofreadPageNamespaceNames['ar'] = [
	'page' => 'صفحة',
	'page_talk' => 'نقاش_الصفحة',
	'index' => 'فهرس',
	'index_talk' => 'نقاش_الفهرس'
];

/** Assamese (অসমীয়া) */
$proofreadPageNamespaceNames['as'] = [
	'page' => 'পৃষ্ঠা',
	'page_talk' => 'পৃষ্ঠা_আলোচনা',
	'index' => 'সূচী',
	'index_talk' => 'সূচী_আলোচনা'
];

/** Basa Bali (Basa Bali) */
$proofreadPageNamespaceNames['ban'] = [
	'page' => 'Kaca',
	'page_talk' => 'Pabligbagan_Kaca',
	'index' => 'Indéks',
	'index_talk' => 'Pabligbagan_Indéks',
];

/** Belarusian (беларуская) */
$proofreadPageNamespaceNames['be'] = [
	'page' => 'Старонка',
	'page_talk' => 'Размовы_пра_старонку',
	'index' => 'Індэкс',
	'index_talk' => 'Размовы_пра_індэкс'
];

/** Bengali (বাংলা) */
$proofreadPageNamespaceNames['bn'] = [
	'page' => 'পাতা',
	'page_talk' => 'পাতা_আলাপ',
	'index' => 'নির্ঘণ্ট',
	'index_talk' => 'নির্ঘণ্ট_আলাপ'
];

/** Breton (brezhoneg) */
$proofreadPageNamespaceNames['br'] = [
	'page' => 'Pajenn',
	'page_talk' => 'Kaozeadenn_pajenn',
	'index' => 'Meneger',
	'index_talk' => 'Kaozeadenn_meneger'
];

/** Catalan (català) */
$proofreadPageNamespaceNames['ca'] = [
	'page' => 'Pàgina',
	'page_talk' => 'Pàgina_Discussió',
	'index' => 'Llibre',
	'index_talk' => 'Llibre_Discussió'
];

/** Czech (česky) */
$proofreadPageNamespaceNames['cs'] = [
	'page' => 'Stránka',
	'page_talk' => 'Diskuse_ke_stránce',
	'index' => 'Index',
	'index_talk' => 'Diskuse_k_indexu'
];

/** Welsh (Cymraeg) */
$proofreadPageNamespaceNames['cy'] = [
	'page' => 'Tudalen',
	'page_talk' => 'Sgwrs_Tudalen',
	'index' => 'Indecs',
	'index_talk' => 'Sgwrs_Indecs'
];

/** Danish (dansk) */
$proofreadPageNamespaceNames['da'] = [
	'page' => 'Side',
	'page_talk' => 'Sidediskussion',
	'index' => 'Indeks',
	'index_talk' => 'Indeksdiskussion'
];

/** German (Deutsch) */
$proofreadPageNamespaceNames['de'] = [
	'page' => 'Seite',
	'page_talk' => 'Seite_Diskussion',
	'index' => 'Index',
	'index_talk' => 'Index_Diskussion'
];

/** Greek (Ελληνικά) */
$proofreadPageNamespaceNames['el'] = [
	'page' => 'Σελίδα',
	'page_talk' => 'Συζήτηση_σελίδας',
	'index' => 'Μεταγραφή',
	'index_talk' => 'Συζήτηση_μεταγραφής'
];

/** Esperanto (Esperanto) */
$proofreadPageNamespaceNames['eo'] = [
	'page' => 'Paĝo',
	'page_talk' => 'Paĝo-Diskuto',
	'index' => 'Indekso',
	'index_talk' => 'Indekso-Diskuto'
];

/** Spanish (español) */
$proofreadPageNamespaceNames['es'] = [
	'page' => 'Página',
	'page_talk' => 'Página_Discusión',
	'index' => 'Índice',
	'index_talk' => 'Índice_Discusión'
];

/** Estonian (eesti) */
$proofreadPageNamespaceNames['et'] = [
	'page' => 'Lehekülg',
	'page_talk' => 'Lehekülje_arutelu',
	'index' => 'Register',
	'index_talk' => 'Registri_arutelu'
];

/** Basque (Euskara) */
$proofreadPageNamespaceNames['eu'] = [
	'page' => 'Orrialde',
	'page_talk' => 'Orrialde_eztabaida',
	'index' => 'Aurkibide',
	'index_talk' => 'Aurkibide_eztabaida',
];

/** Persian (فارسی) */
$proofreadPageNamespaceNames['fa'] = [
	'page' => 'برگه',
	'page_talk' => 'گفتگوی برگه',
	'index' => 'فهرست',
	'index_talk' => 'گفتگوی_فهرست'
];

/** Finnish (suomi) */
$proofreadPageNamespaceNames['fi'] = [
	'page' => 'Sivu',
	'page_talk' => 'Keskustelu_sivusta',
	'index' => 'Hakemisto',
	'index_talk' => 'Keskustelu_hakemistosta'
];

/** French (Français) */
$proofreadPageNamespaceNames['fr'] = [
	'page' => 'Page',
	'page_talk' => 'Discussion_Page',
	'index' => 'Livre',
	'index_talk' => 'Discussion_Livre'
];

/** Northern Frisian (Nordfriisk) */
$proofreadPageNamespaceNames['frr'] = [
	'page' => 'Seite',
	'page_talk' => 'Seite_Diskussion',
	'index' => 'Index',
	'index_talk' => 'Index_Diskussion'
];

/** Galician (Galego) */
$proofreadPageNamespaceNames['gl'] = [
	'page' => 'Páxina',
	'page_talk' => 'Conversa_páxina',
	'index' => 'Índice',
	'index_talk' => 'Conversa_índice'
];

/** Gujarati (ગુજરાતી) */
$proofreadPageNamespaceNames['gu'] = [
	'page' => 'પૃષ્ઠ',
	'page_talk' => 'પૃષ્ઠ_ચર્ચા',
	'index' => 'સૂચિ',
	'index_talk' => 'સૂચિ_ચર્ચા'
];

/** Hebrew (עברית) */
$proofreadPageNamespaceNames['he'] = [
	'page' => 'עמוד',
	'page_talk' => 'שיחת_עמוד',
	'index' => 'מפתח',
	'index_talk' => 'שיחת_מפתח'
];

/** Hindi (हिन्दी) */
$proofreadPageNamespaceNames['hi'] = [
	'page' => 'पृष्ठ',
	'page_talk' => 'पृष्ठ_वार्ता',
	'index' => 'विषयसूची',
	'index_talk' => 'विषयसूची_वार्ता'
];

/** Croatian (hrvatski) */
$proofreadPageNamespaceNames['hr'] = [
	'page' => 'Stranica',
	'page_talk' => 'Razgovor_o_stranici',
	'index' => 'Sadržaj',
	'index_talk' => 'Razgovor_o_sadržaju'
];

/** Hungarian (magyar) */
$proofreadPageNamespaceNames['hu'] = [
	'page' => 'Oldal',
	'page_talk' => 'Oldal_vita',
	'index' => 'Index',
	'index_talk' => 'Index_vita'
];

/** Armenian (Հայերեն) */
$proofreadPageNamespaceNames['hy'] = [
	'page' => 'Էջ',
	'page_talk' => 'Էջի_քննարկում',
	'index' => 'Ինդեքս',
	'index_talk' => 'Ինդեքսի_քննարկում'
];

/** Indonesian (Bahasa Indonesia) */
$proofreadPageNamespaceNames['id'] = [
	'page' => 'Halaman',
	'page_talk' => 'Pembicaraan_Halaman',
	'index' => 'Indeks',
	'index_talk' => 'Pembicaraan_Indeks'
];

/** Icelandic (íslenska) */
$proofreadPageNamespaceNames['is'] = [
	'page' => 'Blaðsíða',
	'page_talk' => 'Blaðsíðuspjall',
	'index' => 'Frumrit',
	'index_talk' => 'Frumritsspjall'
];

/** Italian (italiano) */
$proofreadPageNamespaceNames['it'] = [
	'page' => 'Pagina',
	'page_talk' => 'Discussioni_pagina',
	'index' => 'Indice',
	'index_talk' => 'Discussioni_indice'
];

/** Javanese (Jawa) */
$proofreadPageNamespaceNames['jv'] = [
	'page' => 'Kaca',
	'page_talk' => 'Parembugan_Kaca',
	'index' => 'Indhèks',
	'index_talk' => 'Parembugan_Indhèks',
];

/** Kannada (ಕನ್ನಡ) */
$proofreadPageNamespaceNames['kn'] = [
	'page' => 'ಪುಟ',
	'page_talk' => 'ಪುಟ_ಚರ್ಚೆ',
	'index' => 'ಪರಿವಿಡಿ',
	'index_talk' => 'ಪರಿವಿಡಿ_ಚರ್ಚೆ'
];

/** Korean (한국어) */
$proofreadPageNamespaceNames['ko'] = [
	'page' => '페이지',
	'page_talk' => '페이지토론',
	'index' => '색인',
	'index_talk' => '색인토론',
];

/** Latin (Latina) */
$proofreadPageNamespaceNames['la'] = [
	'page' => 'Pagina',
	'page_talk' => 'Disputatio_Paginae',
	'index' => 'Liber',
	'index_talk' => 'Disputatio_Libri'
];

/** Ligurian (ligure) */
$proofreadPageNamespaceNames['lij'] = [
	'page' => 'Pagina',
	'page_talk' => 'Discuscion_pagina',
	'index' => 'Ìndiçe',
	'index_talk' => 'Discuscion_ìndiçe',
];

/** Malayalam (മലയാളം) */
$proofreadPageNamespaceNames['ml'] = [
	'page' => 'താൾ',
	'page_talk' => 'താളിന്റെ_സംവാദം',
	'index' => 'സൂചിക',
	'index_talk' => 'സൂചികയുടെ_സംവാദം'
];

/** Marathi (मराठी) */
$proofreadPageNamespaceNames['mr'] = [
	'page' => 'पान',
	'page_talk' => 'पान_चर्चा',
	'index' => 'अनुक्रमणिका',
	'index_talk' => 'अनुक्रमणिका_चर्चा'
];

/** Neapolitan (Napulitano) */
$proofreadPageNamespaceNames['nap'] = [
	'page' => 'Paggena',
	'page_talk' => 'Paggena_chiàcchiera',
	'index' => 'Ennece',
	'index_talk' => 'Ennece_chiàcchiera'
];

/** Norwegian (bokmål)‬ (‪norsk (bokmål)‬) */
$proofreadPageNamespaceNames['nb'] = [
	'page' => 'Side',
	'page_talk' => 'Sidediskusjon',
	'index' => 'Indeks',
	'index_talk' => 'Indeksdiskusjon'
];

/** Dutch (Nederlands) */
$proofreadPageNamespaceNames['nl'] = [
	'page' => 'Pagina',
	'page_talk' => 'Overleg_pagina',
	'index' => 'Index',
	'index_talk' => 'Overleg_index'
];

/** N'Ko (ߒߞߏ) */
$proofreadPageNamespaceNames['nqo'] = [
	'page' => 'ߞߐߜߍ',
	'page_talk' => 'ߞߐߜߍ ߢߊߝߐߞߣߍ',
	'index' => 'ߓߊߕߐ߲ߛߐ߲',
	'index_talk' => 'ߓߊߕߐ߲ߛߐ߲ ߢߊߝߐߞߣߍ',
];

/** Oriya (ଓଡ଼ିଆ) */
$proofreadPageNamespaceNames['or'] = [
	'page' => 'ପୃଷ୍ଠା',
	'page_talk' => 'ପୃଷ୍ଠା_ଆଲୋଚନା',
	'index' => 'ସୂଚୀ',
	'index_talk' => 'ସୂଚୀ_ଆଲୋଚନା'
];

/** Punjabi (ਪੰਜਾਬੀ) */
$proofreadPageNamespaceNames['pa'] = [
	'page' => 'ਪੰਨਾ',
	'page_talk' => 'ਪੰਨਾ_ਗੱਲ-ਬਾਤ',
	'index' => 'ਇੰਡੈਕਸ',
	'index_talk' => 'ਇੰਡੈਕਸ_ਗੱਲ-ਬਾਤ'
];

/** Nigerian Pidgin (Naijá) */
$proofreadPageNamespaceNames['pcm'] = [
	'page' => 'Dokument_pej',
	'page_talk' => 'Dokument_pej_tok_abaut_am',
	'index' => 'Index',
	'index_talk' => 'Index_tok_abaut_am',
];

/** Polish (polski) */
$proofreadPageNamespaceNames['pl'] = [
	'page' => 'Strona',
	'page_talk' => 'Dyskusja_strony',
	'index' => 'Indeks',
	'index_talk' => 'Dyskusja_indeksu'
];

/** Piedmontese (Piemontèis) */
$proofreadPageNamespaceNames['pms'] = [
	'page' => 'Pàgina',
	'page_talk' => 'Discussion_ëd_la_pàgina',
	'index' => 'Tàula',
	'index_talk' => 'Discussion_ëd_la_tàula'
];

/** Portuguese (português) */
$proofreadPageNamespaceNames['pt'] = [
	'page' => 'Página',
	'page_talk' => 'Página_Discussão',
	'index' => 'Galeria',
	'index_talk' => 'Galeria_Discussão'
];

/** Romanian (română) */
$proofreadPageNamespaceNames['ro'] = [
	'page' => 'Pagină',
	'page_talk' => 'Discuție_Pagină',
	'index' => 'Index',
	'index_talk' => 'Discuție_Index'
];

/** Russian (русский) */
$proofreadPageNamespaceNames['ru'] = [
	'page' => 'Страница',
	'page_talk' => 'Обсуждение_страницы',
	'index' => 'Индекс',
	'index_talk' => 'Обсуждение_индекса'
];

/** Sanskrit (संस्कृतम्) */
$proofreadPageNamespaceNames['sa'] = [
	'page' => 'पृष्ठम्',
	'page_talk' => 'पृष्ठसम्भाषणम्',
	'index' => 'अनुक्रमणिका',
	'index_talk' => 'अनुक्रमणिकासम्भाषणम्',
];

$proofreadPageNamespaceAliases['sa'] = [
	'page' => [ 'पुटम्' ],
	'page_talk' => [ 'पुटसंवाद' ],
	'index_talk' => [ 'अनुक्रमणिकासंवाद' ],
];

/** Slovenian (slovenščina) */
$proofreadPageNamespaceNames['sl'] = [
	'page' => 'Stran',
	'page_talk' => 'Pogovor_o_strani',
	'index' => 'Kazalo',
	'index_talk' => 'Pogovor_o_kazalu'
];

/** Serbian Cyrillic (српски (ћирилица)) */
$proofreadPageNamespaceNames['sr-ec'] = [
	'page' => 'Страница',
	'page_talk' => 'Разговор_о_страници',
	'index' => 'Индекс',
	'index_talk' => 'Разговор_о_индексу'
];

/** Serbian Latin (srpski (latinica)) */
$proofreadPageNamespaceNames['sr-el'] = [
	'page' => 'Stranica',
	'page_talk' => 'Razgovor_o_stranici',
	'index' => 'Indeks',
	'index_talk' => 'Razgovor_o_indeksu'
];

/** Sundanese (basa Sunda) */
$proofreadPageNamespaceNames['su'] = [
	'page' => 'Kaca',
	'page_talk' => 'Obrolan_kaca',
	'index' => 'Indéks',
	'index_talk' => 'Obrolan_indéks'
];

/** Swedish (svenska) */
$proofreadPageNamespaceNames['sv'] = [
	'page' => 'Sida',
	'page_talk' => 'Siddiskussion',
	'index' => 'Index',
	'index_talk' => 'Indexdiskussion'
];

/** Tamil (தமிழ்) */
$proofreadPageNamespaceNames['ta'] = [
	'page' => 'பக்கம்',
	'page_talk' => 'பக்கம்_பேச்சு',
	'index' => 'அட்டவணை',
	'index_talk' => 'அட்டவணை_பேச்சு'
];

/** Telugu (తెలుగు) */
$proofreadPageNamespaceNames['te'] = [
	'page' => 'పుట',
	'page_talk' => 'పుట_చర్చ',
	'index' => 'సూచిక',
	'index_talk' => 'సూచిక_చర్చ'
];

/** Thai (ไทย) */
$proofreadPageNamespaceNames['th'] = [
	'page' => 'หน้า',
	'page_talk' => 'คุยเรื่องหน้า',
	'index' => 'ดัชนี',
	'index_talk' => 'คุยเรื่องดัชนี'
];

/** Turkish (Türkçe) */
$proofreadPageNamespaceNames['tr'] = [
	'page' => 'Sayfa',
	'page_talk' => 'Sayfa_tartışma',
	'index' => 'Dizin',
	'index_talk' => 'Dizin_tartışma'
];

/** Ukrainian (украї́нська) */
$proofreadPageNamespaceNames['uk'] = [
	'page' => 'Сторінка',
	'page_talk' => 'Обговорення_сторінки',
	'index' => 'Індекс',
	'index_talk' => 'Обговорення_індексу',
];

/** vèneto (vèneto) */
$proofreadPageNamespaceNames['vec'] = [
	'page' => 'Pagina',
	'page_talk' => 'Discussion_pagina',
	'index' => 'Indice',
	'index_talk' => 'Discussion_indice'
];

/** Vietnamese (Tiếng Việt) */
$proofreadPageNamespaceNames['vi'] = [
	'page' => 'Trang',
	'page_talk' => 'Thảo_luận_Trang',
	'index' => 'Mục_lục',
	'index_talk' => 'Thảo_luận_Mục_lục'
];

/** Walloon (walon) */
$proofreadPageNamespaceNames['wa'] = [
	'page' => 'Pådje',
	'page_talk' => 'Pådje_copene',
	'index' => 'Indek',
	'index_talk' => 'Indek_copene',
];
