<?php
/**
 * Aliases for special pages
 *
 * @file
 * @ingroup Extensions
 */

$specialPageAliases = [];

/** English (English) */
$specialPageAliases['en'] = [
	'IndexPages' => [ 'IndexPages' ],
	'PagesWithoutScans' => [ 'PagesWithoutScans' ],
];

/** Arabic (العربية) */
$specialPageAliases['ar'] = [
	'IndexPages' => [ 'صفحات_الفهرس' ],
	'PagesWithoutScans' => [ 'صفحات_بدون_فحص' ],
];

/** Egyptian Arabic (مصرى) */
$specialPageAliases['arz'] = [
	'IndexPages' => [ 'صفحات_الفهرس' ],
	'PagesWithoutScans' => [ 'صفحات_من_غير_فحص' ],
];

/** Assamese (অসমীয়া) */
$specialPageAliases['as'] = [
	'IndexPages' => [ 'সমল_পৃষ্ঠাসমূহ' ],
];

/** Western Balochi (بلوچی رخشانی) */
$specialPageAliases['bgn'] = [
	'IndexPages' => [ 'تاکدیمانی_لڑلیست' ],
	'PagesWithoutScans' => [ 'بی_سکن_ئین_دیمان' ],
];

/** Breton (brezhoneg) */
$specialPageAliases['br'] = [
	'IndexPages' => [ 'PajennoùMeneger' ],
];

/** Danish (dansk) */
$specialPageAliases['da'] = [
	'IndexPages' => [ 'Indekssider' ],
	'PagesWithoutScans' => [ 'Sider_uden_billeder' ],
];

/** German (Deutsch) */
$specialPageAliases['de'] = [
	'IndexPages' => [ 'Seiten_indexieren' ],
	'PagesWithoutScans' => [ 'Seiten_ohne_Scans' ],
];

/** Zazaki (Zazaki) */
$specialPageAliases['diq'] = [
	'IndexPages' => [ 'Perraİndeks' ],
	'PagesWithoutScans' => [ 'PerréBéCıgeyrayışi' ],
];

/** Estonian (eesti) */
$specialPageAliases['et'] = [
	'IndexPages' => [ 'Registrid' ],
	'PagesWithoutScans' => [ 'Skannimata_tekstid' ],
];

/** Persian (فارسی) */
$specialPageAliases['fa'] = [
	'IndexPages' => [ 'فهرست_صفحه‌ها' ],
	'PagesWithoutScans' => [ 'صفحه‌های_بدون_پویش‌ها' ],
];

/** Hebrew (עברית) */
$specialPageAliases['he'] = [
	'IndexPages' => [ 'דפי_מפתח', 'רשימת_דפי_מפתח' ],
	'PagesWithoutScans' => [ 'דפים_ללא_סריקות' ],
];

/** Haitian (Kreyòl ayisyen) */
$specialPageAliases['ht'] = [
	'IndexPages' => [ 'PajEndèks' ],
];

/** Interlingua (interlingua) */
$specialPageAliases['ia'] = [
	'IndexPages' => [ 'Paginas_de_indice' ],
	'PagesWithoutScans' => [ 'Paginas_non_transcludite' ],
];

/** Italian (italiano) */
$specialPageAliases['it'] = [
	'IndexPages' => [ 'PagineIndice' ],
	'PagesWithoutScans' => [ 'PagineSenzaScansioni' ],
];

/** Japanese (日本語) */
$specialPageAliases['ja'] = [
	'IndexPages' => [ '索引ページ' ],
	'PagesWithoutScans' => [ 'スキャンのないページ' ],
];

/** Korean (한국어) */
$specialPageAliases['ko'] = [
	'IndexPages' => [ '색인문서' ],
	'PagesWithoutScans' => [ '스캔안된문서', '스캔안한문서' ],
];

/** Luxembourgish (Lëtzebuergesch) */
$specialPageAliases['lb'] = [
	'IndexPages' => [ 'Säiten_indexéieren' ],
	'PagesWithoutScans' => [ 'Säiten_ouni_Scan' ],
];

/** Macedonian (македонски) */
$specialPageAliases['mk'] = [
	'IndexPages' => [ 'ИндексираниСтраници' ],
	'PagesWithoutScans' => [ 'СтранициБезПроверки' ],
];

/** Malayalam (മലയാളം) */
$specialPageAliases['ml'] = [
	'IndexPages' => [ 'സൂചികാതാളുകൾ' ],
	'PagesWithoutScans' => [ 'സ്കാൻലഭ്യമല്ലാത്തതാളുകൾ' ],
];

/** Neapolitan (Napulitano) */
$specialPageAliases['nap'] = [
	'IndexPages' => [ 'PaggeneEnnece' ],
	'PagesWithoutScans' => [ 'PaggeneSenzaScan' ],
];

/** Norwegian Bokmål (norsk bokmål) */
$specialPageAliases['nb'] = [
	'IndexPages' => [ 'Indekssider' ],
	'PagesWithoutScans' => [ 'Sider_uten_skanninger' ],
];

/** Low Saxon (Netherlands) (Nedersaksies) */
$specialPageAliases['nds-nl'] = [
	'IndexPages' => [ 'Indexziejen' ],
	'PagesWithoutScans' => [ 'Ziejen_zonder_deurlochting' ],
];

/** Dutch (Nederlands) */
$specialPageAliases['nl'] = [
	'IndexPages' => [ 'Indexpaginas', 'Indexpagina\'s' ],
	'PagesWithoutScans' => [ 'PaginasZonderScans', 'Pagina\'sZonderScans' ],
];

/** Portuguese (português) */
$specialPageAliases['pt'] = [
	'IndexPages' => [ 'Páginas_índice' ],
	'PagesWithoutScans' => [ 'Páginas_sem_digitalizações' ],
];

/** Sicilian (sicilianu) */
$specialPageAliases['scn'] = [
	'IndexPages' => [ 'PagineIndicizzate' ],
	'PagesWithoutScans' => [ 'PagineSenzaScansioni' ],
];

/** Swedish (svenska) */
$specialPageAliases['sv'] = [
	'IndexPages' => [ 'Indexsidor' ],
];

/** Turkish (Türkçe) */
$specialPageAliases['tr'] = [
	'IndexPages' => [ 'DizinSayfaları', 'SayfaEndeksle' ],
	'PagesWithoutScans' => [ 'TaranmamışSayfalar', 'TaramasızSayfalar' ],
];

/** Venetian (vèneto) */
$specialPageAliases['vec'] = [
	'IndexPages' => [ 'PagineDeIndice' ],
	'PagesWithoutScans' => [ 'PagineSensaScansion' ],
];

/** Vietnamese (Tiếng Việt) */
$specialPageAliases['vi'] = [
	'IndexPages' => [ 'Trang_mục_lục' ],
	'PagesWithoutScans' => [ 'Trang_không_có_hình_quét' ],
];

/** Simplified Chinese (中文（简体）) */
$specialPageAliases['zh-hans'] = [
	'IndexPages' => [ '索引页面' ],
	'PagesWithoutScans' => [ '未扫描页面' ],
];

/** Traditional Chinese (中文（繁體）) */
$specialPageAliases['zh-hant'] = [
	'IndexPages' => [ '索引頁面' ],
	'PagesWithoutScans' => [ '未掃描頁面' ],
];
